  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  'Ceiling Space Heat Recovery Controller (Basic).
  'Phil Porritt, 22/05/2016.
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  Option autorun on
  Option Explicit
  Option Default None
  Option Baudrate 115200
  
  'List of DS18B20's on the Bus.
  Dim Integer TsAmb1=&HFFE244001601E7  'Sensor1 Ambient Temp
  Dim Integer TsRoof=&HFF94580016013C  'Sensor2 Roof Temp
  Dim Integer TsLng1=&HFFA257001601BE  'Sensor3 Lounge/Dining Room Temp
  Dim Integer TsBed1=&HFF2C5A0016014A  'Sensor3 Bed Room Temp
  
  Dim Integer Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7
  Dim Integer LTemp,HTemp,Status,MenuUp
  
  Dim float TempLng1, TempBed1, TempAmb1, TempRoof, TmpDif=1.0
  Dim float TempLng1Min, TempBed1Min, TempAmb1Min, TempRoofMin
  Dim float TempLng1Max, TempBed1Max, TempAmb1Max, TempRoofMax
  
  Dim string Esc=Chr$(27), FanStat, BootTime,KeyPress
  
  
  'Pins used - Inputs
  Dim Integer TsBus=15
  
  
  'Pins used - Outputs
  Dim Integer RlFanHi=2   'Fan Running (Red LED) & connected to this pin
  Dim Integer RlFanLo=3
  Dim Integer RlDamp1=4   'Fan Damper Valve
  Dim Integer RlSpare=5
  Dim Integer StatLed=9   'Status Pin LED (Green) Blinks to show main loop is running
  LCD INIT 23, 24, 25, 26, 17, 18
  
  setpin(StatLed),dout
  Setpin RlFanHi,Dout,OC : Pin(RlFanHi)=1
  Setpin RlFanLo,Dout,OC : Pin(RlFanLo)=1
  Setpin RlDamp1,Dout,OC : Pin(RlDamp1)=1
  Setpin RlSpare,Dout,OC : Pin(RlSpare)=1
  
  Print Esc+"[2J"
  
  ReadTemps
  
  If TempRoofMax=0 And TempRoofMin=0 Then
    TempRoofMax=TempRoof
    TempRoofMin=TempRoof
    TempLng1Max=TempLng1
    TempLng1Min=TempLng1
  EndIf
  
  BootTime=Time$
  
  
  
  Do
    Watchdog 20000                    'Reset after 20 second if the program stops
    
    KeyPress = INKEY$
    
    ChkCon
        
    Pin(StatLed)=Not Pin(StatLed)     'Invert Status LED with each loop to show main loop is still running
    
    ' Get the Temperatures at timer interval
    if timer>5000 then
      Pin(StatLed)=1                  'Hold Status LED on whilst reading temps
      ReadTemps
      Timer=0
    Endif
    
    'Update Maximum & Minimum Temps
    If TempRoof>TempRoofMax Then TempRoofMax=TempRoof
    If TempRoof<TempRoofMin Then TempRoofMin=TempRoof
    If TempLng1>TempLng1Max Then TempLng1Max=TempLng1
    If TempLng1<TempLng1Min Then TempLng1Min=TempRoof
    
    'Start fan & open damper if conditions are met
    If TempLng1<=(TempRoof - TmpDif) Then
      FanStat="Running" 'Turn the Fan on & open the damper
      pin(RlFanHi)=0 : Pin(RlDamp1)=0
    else if TempLng1>(TempRoof-TmpDif+0.5) then
      FanStat="Off" 'Turn the Fan off.
      pin(RlFanHi)=1 : Pin(RlDamp1)=1
    endif
    
    UpdateLCD                         'Update LCD Display.
    IF MenuUp=0 Then UpdateConsole    'Update Console if menu is not up.
    
    UpdateLCD 'Update LCD Display & Output data to Console.
    
    
  Loop
  
Sub ChkCon
    
    SELECT CASE KeyPress
      CASE "m","M"
        DoMenu
      CASE "1"
        If MenuUp=1 Then PRINT "Changing Maximum Roof Temperature"
        input "Maximum Roof Temp";TempRoofMax
        Print "Maximum Roof Temp Set to:- ";TempRoofMax
      CASE "2"
        If MenuUp=1 Then PRINT "Changing Differential"
      CASE "3"
        If MenuUp=1 Then PRINT "Changing Solar Level"
      CASE "9"
        If MenuUp=1 Then
          PRINT "Stop & Shutdown"
END ' only end program if menu is showing
        End if
      CASE "0"
        If MenuUp=1 Then PRINT "Exiting"
        EndMenu
    END SELECT
End Sub
  
Sub ReadTemps
  TempAmb1=ReadTemp(TsAmb1)
  TempRoof=ReadTemp(TsRoof)
  TempLng1=ReadTemp(TsLng1)
  TempBed1=ReadTemp(TsBed1)
End Sub
  
  
  '========================OneWire Temperature Function=========================
  ' Get the temperatures from DS18B20 - multiple probes on a single pin
  '=============================================================================
Function ReadTemp(TsSerial As Integer) As Float
  
  Ts1=(TsSerial >> 48) and &hFF : Ts2=(TsSerial >> 40) and &hFF : Ts3=(TsSerial >> 32) and &hFF
  Ts4=(TsSerial >> 24) and &hFF : Ts5=(TsSerial >> 16) and &hFF : Ts6=(TsSerial >> 8)  and &hFF : Ts7=(TsSerial) and &hFF
  OneWire Write TsBus, 1, 10, &H55,&H28,Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7,&H44
  
  'Check sensor is ready
  Timer=0 : Status=0
  Do
    If Timer > 1000 Then Error "Sensor Error"
    OneWire Read TsBus, 4, 1, Status   ' Conversion status
  Loop Until Status = 1
  
  OneWire Write TsBus, 1, 10, &H55,&H28,Ts1,Ts2,Ts3,Ts4,Ts5,Ts6,Ts7,&HBE
  OneWire Read TsBus, 2, 2, LTemp, HTemp
  
  'Calculate the Temp in C
  ReadTemp=((HTemp And &b111) * 256 + LTemp) / 16
  If HTemp And &b1000 Then ReadTemp=(ReadTemp-128)  'Adjust if negative
  
End Function
  '===========================End of Temp Routines==============================
  
Sub UpdateLCD
  
  LCD 1, 1, "Lounge  Temp" : lcd 1,17, Str$(TempLng1,2,1)
  LCD 2, 1, "Bedroom Temp" : LCD 2,17, Str$(TempBed1,2,1)
  LCD 3, 1, "Ambient Temp" : LCD 3,17, Str$(TempAmb1,2,1)
  LCD 4, 1, "Roof    Temp" : LCD 4,17, Str$(TempRoof,2,1)
End Sub
  
Sub UpdateConsole
  'Output Stuff to console for debugging purposes
  Print Esc+"[f";
  'Print Esc+"[2J";
  Print Esc+"[f";
  Print "Lounge  Temp =   ", Str$(TempLng1,2,1)
  Print "Bedroom Temp =   ", Str$(TempBed1,2,1)
  Print "Ambient Temp =   ", Str$(TempAmb1,2,1)
  Print "Roof    Temp =   ", Str$(TempRoof,2,1)
  Print
  Print "Maximum & Minimum Temps"
  Print "Lounge  Max  =   ", Str$(TempLng1Max,2,1)
  Print "Lounge  Min  =   ", Str$(TempLng1Min,2,1)
  Print "Roof    Max  =   ", Str$(TempRoofMax,2,1)
  Print "Roof    Min  =   ", Str$(TempRoofMin,2,1)
  Print
  Print "System Status:-"
  Print "Current Up Time is:- ", Time$
  'Print "Last Boot Time:-  ", BootTime
End Sub
  
  '===========================Console Menu Routines==============================
  
Sub DoMenu
  SETTICK 30000, EndMenu,4 '  Set menu timeout to 30 seconds
  'Output Stuff to console for debugging purposes
  Print Esc+"[2J";
  Print Esc+"[f";
  Print "1. Change Maximum Roof Temperature"
  Print "2. Change Differential"
  Print "3. Change Solar Level"
  Print "9. Stop & Shutdown"
  Print "0. Exit"
  MenuUp = 1 ' a flag so you know when the menu is active
End sub
  
SUB EndMenu
  SETTICK 0,0,4 ' disable the menu timeout
  PRINT Esc+"[2J";
  MenuUp = 0 ' reset menu active flag
END SUB
